<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Exception\OAuth;

use Mambo\Exception\MamboError;

class OAuthError
{
    private string $type;
    private string $error;
    private string $errorDescription;
    private string $errorUri;

    public function __construct(mixed $response = null)
    {
        if (!$response) {
            return;
        }

        $this->type = $response['type'];
        $this->error = $response['error'];
        $this->errorDescription = $response['error_description'];
        $this->errorUri = $response['error_uri'];
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getError(): string
    {
        return $this->error;
    }

    public function getErrorDescription(): string
    {
        return $this->errorDescription;
    }

    public function getErrorUri(): string
    {
        return $this->errorUri;
    }

    public function asMamboError(): MamboError
    {
        $mamboError = new MamboError();
        $mamboError->setType($this->type);
        $mamboError->setMessage($this->errorDescription);
        return $mamboError;
    }
}
