<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Exception;

class MamboError
{
	private array $params = [];
	private string $type;
	private string $message;

	public function __construct(mixed $response = null)
	{
		if (!$response) {
			return;
		}

		$this->type = $response['error']['type'];
		$this->message = $response['error']['message'];

		if (!isset($response['error']['params'])) {
			return;
		}

		foreach ($response['error']['params'] as $param) {
			$this->params[] = new ParameterError($param['name'], $param['message']);
		}
	}

	public function getType(): string
	{
		return $this->type;
	}

	public function setType(string $type): void
	{
		$this->type = $type;
	}

	public function getMessage(): string
	{
		return $this->message;
	}

	public function setMessage(string $message): void
	{
		$this->message = $message;
	}

	public function getDetailedMessage(): string
	{
		if (empty($this->getValidationErrors())) {
			return $this->getMessage();
		}
		return sprintf("%s Errors: %s", $this->type, implode(', ', $this->getValidationErrors()));
	}

	public function getValidationErrors(): array
	{
		return $this->params;
	}
}
