<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Exception;

class MamboApiException extends MamboException
{
    private MamboError $error;
    private int $status;

    public function __construct(MamboError $error, int $status)
    {
        parent::__construct($error->getMessage());
        $this->status = $status;
        $this->error = $error;
    }

    public function getMamboError(): MamboError
    {
        return $this->error;
    }

    public function getType(): string
    {
        return $this->error->getType();
    }

    public function getValidationErrors(): ?array
    {
        return $this->error->getValidationErrors();
    }

    public function getHttpStatus(): int
    {
        return $this->status;
    }
}
