<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Webhook\Param;

use Mambo\Common\Param\AbstractServiceParams;
use Mambo\Common\Param\ServiceParams;

/**
 * Parameters for retrieving webhook lists
 * @extends AbstractServiceParams<WebhookGetListParams>
 */
class WebhookGetListParams extends AbstractServiceParams implements ServiceParams
{

    /**
     * Specifies the number of results to retrieve (1-100)
     * @param int $pageSize
     * @return self
     */
    public function pageSize(int $pageSize): self
    {
        return $this->extraParams('pageSize', (string)$pageSize);
    }

    /**
     * Specifies the cursor after which to retrieve records
     * @param string $pageAfter
     * @return self
     */
    public function pageAfter(string $pageAfter): self
    {
        return $this->extraParams('pageAfter', $pageAfter);
    }

    /**
     * Specifies the cursor before which to retrieve records
     * @param string $pageBefore
     * @return self
     */
    public function pageBefore(string $pageBefore): self
    {
        return $this->extraParams('pageBefore', $pageBefore);
    }
}
