<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\User\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for getting user point transactions
 * @extends AbstractServiceParams<UserGetPointTransactionsParams>
 */
class UserGetPointTransactionsParams extends AbstractServiceParams
{
    /**
     * The transaction type to filter by
     */
    public function transactionType(string $transactionType): self
    {
        return $this->extraParams('transactionType', $transactionType);
    }

    /**
     * Filter for points greater than this value
     */
    public function greaterThan(int $greaterThan): self
    {
        return $this->extraParams('greaterThan', $greaterThan);
    }

    /**
     * Filter for points lower than this value
     */
    public function lowerThan(int $lowerThan): self
    {
        return $this->extraParams('lowerThan', $lowerThan);
    }

    /**
     * Page size for results
     */
    public function pageSize(int $pageSize): self
    {
        return $this->extraParams('pageSize', $pageSize);
    }

    /**
     * Cursor after which to retrieve records
     */
    public function pageAfter(string $pageAfter): self
    {
        return $this->extraParams('pageAfter', $pageAfter);
    }

    /**
     * Cursor before which to retrieve records
     */
    public function pageBefore(string $pageBefore): self
    {
        return $this->extraParams('pageBefore', $pageBefore);
    }

    /**
     * Properties to expand
     * @param array<string> $expand
     */
    public function expand(array $expand): self
    {
        return $this->extraParamsList('expand', $expand);
    }
}
