<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\User\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for getting user notifications
 * @extends AbstractServiceParams<UserGetNotificationsParams>
 */
class UserGetNotificationsParams extends AbstractServiceParams
{
    /**
     * Specifies the page of results to retrieve.
     */
    public function page(int $page): self
    {
        return $this->extraParams('page', $page);
    }

    /**
     * Specifies the number of results to retrieve, up to a maximum of 100.
     */
    public function count(int $count): self
    {
        return $this->extraParams('count', $count);
    }

    /**
     * The list of tags to filter by
     * @param array<string> $tags
     */
    public function tags(array $tags): self
    {
        return $this->extraParamsList('tags', $tags);
    }

    /**
     * Whether tags should filter for any or all tags
     */
    public function tagsJoin(string $tagsJoin): self
    {
        return $this->extraParams('tagsJoin', $tagsJoin);
    }

    /**
     * Whether to filter by personalization tags
     */
    public function withPersonalization(bool $withPersonalization): self
    {
        return $this->extraParams('withPersonalization', $withPersonalization);
    }

    /**
     * Whether to include activities that triggered notifications
     */
    public function withActivities(bool $withActivities): self
    {
        return $this->extraParams('withActivities', $withActivities);
    }

    /**
     * Whether to include notifications that have already been read (cleared)
     */
    public function withRead(bool $withRead): self
    {
        return $this->extraParams('withRead', $withRead);
    }
}
