<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\User\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for getting a list of users
 * @extends AbstractServiceParams<UserGetListParams>
 */
class UserGetListParams extends AbstractServiceParams
{
    /**
     * Specifies the page of results to retrieve.
     */
    public function page(int $page): self
    {
        return $this->extraParams('page', $page);
    }

    /**
     * Specifies the number of results to retrieve, up to a maximum of 100.
     */
    public function count(int $count): self
    {
        return $this->extraParams('count', $count);
    }

    /**
     * The list of tags to filter by
     * @param array<string> $tags
     */
    public function tags(array $tags): self
    {
        return $this->extraParamsList('tags', $tags);
    }

    /**
     * Whether tags should filter for any or all tags
     */
    public function tagsJoin(string $tagsJoin): self
    {
        return $this->extraParams('tagsJoin', $tagsJoin);
    }

    /**
     * Field to order results by
     */
    public function orderBy(string $orderBy): self
    {
        return $this->extraParams('orderBy', $orderBy);
    }

    /**
     * Sort order for results
     */
    public function order(string $order): self
    {
        return $this->extraParams('order', $order);
    }

    /**
     * Whether to include the users stats
     */
    public function withStats(bool $withStats): self
    {
        return $this->extraParams('withStats', $withStats);
    }

    /**
     * User properties to return
     * @param array<string> $properties
     */
    public function properties(array $properties): self
    {
        return $this->extraParamsList('props', $properties);
    }

    /**
     * Reward IDs to filter by
     * @param array<string> $rewardIds
     */
    public function rewardIds(array $rewardIds): self
    {
        return $this->extraParamsList('rewardIds', $rewardIds);
    }

    /**
     * Behaviour IDs to filter by
     * @param array<string> $behaviourIds
     */
    public function behaviourIds(array $behaviourIds): self
    {
        return $this->extraParamsList('behaviourIds', $behaviourIds);
    }

    /**
     * Users last seen on starting from
     */
    public function lastSeenOnStart(string $lastSeenOnStart): self
    {
        return $this->extraParams('lastSeenOnStart', $lastSeenOnStart);
    }

    /**
     * Users last seen on ending on
     */
    public function lastSeenOnEnd(string $lastSeenOnEnd): self
    {
        return $this->extraParams('lastSeenOnEnd', $lastSeenOnEnd);
    }
}
