<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\User\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for getting a user's leaderboard data
 * @extends AbstractServiceParams<UserGetLeaderboardParams>
 */
class UserGetLeaderboardParams extends AbstractServiceParams
{
    /**
     * Specifies the page of results to retrieve.
     */
    public function page(int $page): self
    {
        return $this->extraParams('page', $page);
    }

    /**
     * Specifies the number of results to retrieve, up to a maximum of 100.
     */
    public function count(int $count): self
    {
        return $this->extraParams('count', $count);
    }

    /**
     * The tag to filter users by
     */
    public function tag(string $tag): self
    {
        return $this->extraParams('tag', $tag);
    }

    /**
     * The period for retrieving the leaderboard
     */
    public function period(string $period): self
    {
        return $this->extraParams('period', $period);
    }

    /**
     * Whether to use contextual view
     */
    public function contextual(bool $contextual): self
    {
        return $this->extraParams('contextual', $contextual);
    }

    /**
     * User properties to return
     * @param array<string> $properties
     */
    public function properties(array $properties): self
    {
        return $this->extraParamsList('props', $properties);
    }
}
