<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\User\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for getting all user achievements
 * @extends AbstractServiceParams<UserGetAllAchievementsParams>
 */
class UserGetAllAchievementsParams extends AbstractServiceParams
{
    /**
     * The list of tags to filter by
     * @param array<string> $tags
     * @return self
     */
    public function tags(array $tags): self
    {
        $this->extraParamsList('tags', $tags);
        return $this;
    }

    /**
     * Whether tags should filter for any or all tags
     * @param string $tagsJoin
     * @return self
     */
    public function tagsJoin(string $tagsJoin): self
    {
        $this->extraParams('tagsJoin', $tagsJoin);
        return $this;
    }

    /**
     * Whether to filter by personalization tags
     * @param bool $withPersonalization
     * @return self
     */
    public function withPersonalization(bool $withPersonalization): self
    {
        $this->extraParams('withPersonalization', $withPersonalization);
        return $this;
    }
}
