<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * /**
 * This class encapsulates data related to synchronising SAML users
 */

declare(strict_types=1);

namespace Mambo\Site\Data\Authentication;

class SamlSyncUserAttributesDto
{
    private $data = array();

    /**
     * The attribute field to use when loading the user unique ID.
     * This will be used as the username on login.
     */
    public function getUuid()
    {
        return $this->data['uuid'];
    }
    public function setUuid(string $uuid)
    {
        $this->data['uuid'] = $uuid;
    }

    /**
     * The attribute field to use when loading the user first name.
     */
    public function getFirstName()
    {
        return $this->data['firstName'];
    }
    public function setFirstName(string $firstName)
    {
        $this->data['firstName'] = $firstName;
    }

    /**
     * The attribute field to use when loading the user last name.
     */
    public function getLastName()
    {
        return $this->data['lastName'];
    }
    public function setLastName(string $lastName)
    {
        $this->data['lastName'] = $lastName;
    }

    /**
     * The attribute field to use when loading the user email.
     */
    public function getEmail()
    {
        return $this->data['email'];
    }
    public function setEmail(string $email)
    {
        $this->data['email'] = $email;
    }

    /**
     * Return the JSON array equivalent of this object
     */
    public function getJsonArray()
    {
        return $this->data;
    }
}
