<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class specify the context with which the SAML authentication runs.
 */

declare(strict_types=1);

namespace Mambo\Site\Data\Authentication;

class SamlAuthenticationContextDto implements AuthenticationContextDto
{
    private $data = array();

    /**
     * The SAML 2.0 Asserting Party (IDP) metadata. This can be
     * added as a URL to the metadata file or as the XML contents
     * of the metadata file.
     */
    public function getMetadata()
    {
        return $this->data['metadata'];
    }
    public function setMetadata($metadata)
    {
        $this->data['metadata'] = $metadata;
    }

    /**
     * Contains the mapping information between an external
     * user directory and the internal Mambo users.
     */
    public function getSyncUserAttributes()
    {
        return $this->data['syncUserAttributes'];
    }
    public function setSyncUserAttributes(SamlSyncUserAttributesDto $syncUserAttributes)
    {
        $this->data['syncUserAttributes'] = $syncUserAttributes;
    }

    /**
     * Default security groups to be associated to the administrators.
     * Note that this property will be ignored for regular users.
     */
    public function getDefaultGroupIds()
    {
        return $this->data['defaultGroupIds'];
    }
    public function setDefaultGroupIds($defaultGroupIds)
    {
        $this->data['defaultGroupIds'] = $defaultGroupIds;
    }

    /**
     * The type of AuthenticationRequestData.
     *
     */
    public function getAuthenticationType()
    {
        return AuthenticationType::SAML;
    }

    /**
     * The type of authentication context parameter settings attribute.
     *
     */
    public function getType()
    {
        return "saml";
    }

    /**
     * Returns the current model as an array ready to
     * be json_encoded
     */
    public function getJsonArray()
    {
        $json = $this->data;
        $json['type'] = $this->getType();
        return $json;
    }
}
