<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class specify the context with which the JWT authentication runs.
 */

declare(strict_types=1);

namespace Mambo\Site\Data\Authentication;

class JwtAuthenticationContextDto implements AuthenticationContextDto
{
    private $data = array();

    /**
     * The URL used to retrieve the JSON Web Key Set used to validate the JWT token
     */
    public function getJwksUrl()
    {
        return $this->data['jwksUrl'];
    }
    public function setJwksUrl($jwksUrl)
    {
        $this->data['jwksUrl'] = $jwksUrl;
    }

    /**
     * The claim in the JWT token which contains the Unique User ID
     */
    public function getUuidClaim()
    {
        return $this->data['uuidClaim'];
    }
    public function setUuidClaim($uuidClaim)
    {
        $this->data['uuidClaim'] = $uuidClaim;
    }

    /**
     * The expected issuer of the JWT token
     */
    public function getIssuer()
    {
        return $this->data['issuer'];
    }
    public function setIssuer($issuer)
    {
        $this->data['issuer'] = $issuer;
    }

    /**
     * The expected audience of the JWT token
     */
    public function getAudience()
    {
        return $this->data['audience'];
    }
    public function setAudience($audience)
    {
        $this->data['audience'] = $audience;
    }

    /**
     * The expected algorithm for the JWT token. Valid algorithms include:
     * 	HS256, HS384, HS512, RS256, RS384, RS512, ES256, ES384, ES512
     */
    public function getAlgorithm()
    {
        return $this->data['algorithm'];
    }
    public function setAlgorithm($algorithm)
    {
        $this->data['algorithm'] = $algorithm;
    }

    /**
     * The type of AuthenticationRequestData.
     *
     */
    public function getAuthenticationType()
    {
        return AuthenticationType::JWT;
    }

    /**
     * The type of authentication context parameter settings attribute.
     *
     */
    public function getType()
    {
        return "jwt";
    }

    /**
     * Returns the current model as an array ready to
     * be json_encoded
     */
    public function getJsonArray()
    {
        $json = $this->data;
        $json['type'] = $this->getType();
        return $json;
    }
}
