<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class encapsulates the data required to redirect
 * users if the log in successfully.
 */

declare(strict_types=1);

namespace Mambo\Site\Data\Authentication;

class AuthenticationRedirectDto
{
	private $data = array();

	/**
	 * Whether the Referer header should be used to redirect
	 * the user which is logging in
	 */
	public function getUseRefererRedirect()
	{
		return $this->data['useRefererRedirect'];
	}
	public function setUseRefererRedirect($useRefererRedirect)
	{
		$this->data['useRefererRedirect'] = $useRefererRedirect;
	}

	/**
	 * This is the default redirect URL. This is used
	 * if no redirect URL is found in the query parameters
	 * and in the Referer header.
	 */
	public function getDefaultRedirectUrl()
	{
		return $this->data['defaultRedirectUrl'];
	}
	public function setDefaultRedirectUrl($defaultRedirectUrl)
	{
		$this->data['defaultRedirectUrl'] = $defaultRedirectUrl;
	}

	/**
	 * Returns the current model as an array ready to
	 * be json_encoded
	 */
	public function getJsonArray()
	{
		return $this->data;
	}
}
