<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Reward\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for retrieving level list
 * @extends AbstractServiceParams<self>
 */
class RewardGetLevelListParams extends AbstractServiceParams
{
    /**
     * Set the list of tags to filter by
     * @param array<string> $tags
     * @return self
     */
    public function tags(array $tags): self
    {
        return $this->extraParamsList('tags', $tags);
    }

    /**
     * Set whether tags should return items containing any/all tags
     * Possible values: hasAnyOf / hasAllOf Default: hasAnyOf
     * @param string $tagsJoin
     * @return self
     */
    public function tagsJoin(string $tagsJoin): self
    {
        return $this->extraParams('tagsJoin', $tagsJoin);
    }

    /**
     * Set the tagUuid to filter the list by personalization tags
     * @param string $tagUuid
     * @return self
     */
    public function tagUuid(string $tagUuid): self
    {
        return $this->extraParams('tagUuid', $tagUuid);
    }

    /**
     * Set the list of point IDs to filter by
     * @param array<string> $pointIds
     * @return self
     */
    public function pointIds(array $pointIds): self
    {
        return $this->extraParamsList('pointIds', $pointIds);
    }
}
