<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class encapsulates data related to a reward's unlock conditions
 */
declare(strict_types=1);

namespace Mambo\Reward\Data;

class UnlockCondition
{
	private $data = array();


	/**
	 * The type of target used to unlock the reward.
	 * Valid types include: point, behaviour and reward
	 */
	public function getType()
	{
		return $this->data['type'];
	}
	public function setType($type)
	{
		$this->data['type'] = (string) $type;
	}

	/**
	 * The ID of the target that needs to be achieved for unlock
	 */
	public function getTargetId()
	{
		return $this->data['targetId'];
	}
	public function setTargetId($targetId)
	{
		$this->data['targetId'] = (string) $targetId;
	}

	/**
	 * The minimum number of times the target must be met to unlock the reward
	 */
	public function getThreshold()
	{
		return $this->data['threshold'];
	}
	public function setThreshold($threshold)
	{
		$this->data['threshold'] = $threshold;
	}


	/**
	 * Returns the current model as an array ready to
	 * be json_encoded
	 */
	public function getJsonArray()
	{
		return $this->data;
	}
}