<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This object captures the data required by the Reward API in
 * order to associate translations to a Reward.
 */

declare(strict_types=1);

namespace Mambo\Reward\Data;

use Mambo\Common\Data\AbstractTranslation;

class RewardTranslation extends AbstractTranslation
{

	/**
	 * The name of the reward. See the achievement or level pages in
	 * administration panel for more information.
	 */
	public function getName()
	{
		return $this->data['name'];
	}
	public function setName($name)
	{
		$this->data['name'] = $name;
	}

	/**
	 * The message associated with the reward. See the achievement or
	 * level pages in administration panel for more information.
	 */
	public function getMessage()
	{
		return $this->data['message'];
	}
	public function setMessage($message)
	{
		$this->data['message'] = $message;
	}

	/**
	 * The hint associated with the reward. See the achievement or level
	 * pages in administration panel for more information.
	 */
	public function getHint()
	{
		return $this->data['hint'];
	}
	public function setHint($hint)
	{
		$this->data['hint'] = $hint;
	}


	/**
	 * Returns the current model as an array ready to
	 * be json_encoded
	 */
	public function getJsonArray()
	{
		return $this->data;
	}
}
