<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This object captures the data required by the Reward API in
 * order to create / update achievements
 */

declare(strict_types=1);

namespace Mambo\Reward\Data;

use Mambo\Common\Data\Recurrence\Recurrence;

class AchievementAttrs
{
	private $data = array();

	/**
	 * The type of attribute
	 */
	public function getType()
	{
		return 'achievement';
	}


	/**
	 * If the achievement is expirable then this field should contain the general
	 * expiration information. See the {@link ExpirationData} object for more information.
	 * Achievements support the following types of reset: never, fixed_period and variable_period
	 */
	public function getExpiration()
	{
		return $this->data['expiration'];
	}
	public function setExpiration(Recurrence $expiration)
	{
		$this->data['expiration'] = $expiration;
	}


	/**
	 * Return the JSON string equivalent of this object
	 */
	public function getJsonArray()
	{
		$json = $this->data;
		$json['type'] = $this->getType();

		if (isset($json['expiration'])) {
			$json['expiration'] = $json['expiration']->getJsonArray();
		}

		return $json;
	}
}
