<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This object captures the data required by the Point API in
 * order to associate decimals to a PointRequestData.
 */

declare(strict_types=1);

namespace Mambo\Point\Data;

class Decimals
{
	private $data = array();


	/**
	 * The precision defines the number of decimal places that should be
	 * used for this point. The default is 0 decimal places and the maximum
	 * is 10 decimal places.
	 */
	public function getPrecision()
	{
		return $this->data['precision'];
	}
	public function setPrecision($precision)
	{
		$this->data['precision'] = $precision;
	}


	/**
	 * The rounding defines how the decimal places should be rounded if
	 * the API receives a point value with more decimal places than
	 * the one specified when configuring the point. Possible rounding values
	 * include: up, down, ceiling, floor, half_up, half_down, half_even
	 */
	public function getRounding()
	{
		return $this->data['rounding'];
	}
	public function setRounding($rounding)
	{
		$this->data['rounding'] = $rounding;
	}


	/**
	 * Return the JSON string equivalent of this object
	 */
	public function getJsonArray()
	{
		return $this->data;
	}
}
