<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Notification\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * @template-extends AbstractServiceParams<NotificationGetListParams>
 */
class NotificationGetListParams extends AbstractServiceParams
{

    /**
     * Specifies the page of results to retrieve.
     *
     * @param int $page
     * @return $this
     */
    public function page(int $page)
    {
        $this->extraParams('page', $page);
        return $this;
    }

    /**
     * Specifies the number of results to retrieve, up to a maximum of 100.
     *
     * @param int $count
     * @return $this
     */
    public function count(int $count)
    {
        $this->extraParams('count', $count);
        return $this;
    }

    /**
     * The list of tags to filter by (if any)
     *
     * @param array<string> $tags
     * @return $this
     */
    public function tags(array $tags)
    {
        $this->extraParamsList('tags', $tags);
        return $this;
    }

    /**
     * Whether the tags should return items containing any one of the tags or
     * whether the tags should return only items containing all of the tags.
     * Possible values: hasAnyOf / hasAllOf Default: hasAnyOf
     *
     * @param string $tagsJoin
     * @return $this
     */
    public function tagsJoin(string $tagsJoin)
    {
        $this->extraParams('tagsJoin', $tagsJoin);
        return $this;
    }

    /**
     * The tagUuid to use to filter the list by personalization tags
     *
     * @param string $tagUuid
     * @return $this
     */
    public function tagUuid(string $tagUuid)
    {
        $this->extraParams('tagUuid', $tagUuid);
        return $this;
    }

    /**
     * Whether to include activities that triggered notifications
     *
     * @param bool $withActivities
     * @return $this
     */
    public function withActivities(bool $withActivities)
    {
        $this->extraParams('withActivities', $withActivities);
        return $this;
    }
}
