<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Kpi\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for retrieving KPI states
 * @extends AbstractServiceParams<KpiGetStatesParams>
 */
class KpiGetStatesParams extends AbstractServiceParams
{

    /**
     * Specifies the page of results to retrieve.
     */
    public function page(int $page): self
    {
        return $this->extraParams('page', (string) $page);
    }

    /**
     * Specifies the number of results to retrieve, up to a maximum of 100.
     */
    public function count(int $count): self
    {
        return $this->extraParams('count', (string) $count);
    }

    /**
     * The list of tags to filter by (if any)
     * @param array<string> $tags
     */
    public function tags(array $tags): self
    {
        return $this->extraParamsList('tags', $tags);
    }

    /**
     * Whether the tags should return items containing any one of the tags or
     * whether the tags should return only items containing all of the tags.
     * Possible values: hasAnyOf / hasAllOf Default: hasAnyOf
     */
    public function tagsJoin(string $tagsJoin): self
    {
        return $this->extraParams('tagsJoin', $tagsJoin);
    }

    /**
     * The tagUuid to use to filter the list by personalization tags
     */
    public function tagUuid(string $tagUuid): self
    {
        return $this->extraParams('tagUuid', $tagUuid);
    }

    /**
     * The period for which to retrieve the KPI states
     */
    public function period(string $period): self
    {
        return $this->extraParams('period', $period);
    }

    /**
     * The year for which to retrieve the KPI states
     */
    public function year(string $year): self
    {
        return $this->extraParams('year', $year);
    }
}
