<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class encapsulates data related to a KPIs RAG status.
 */

declare(strict_types=1);

namespace Mambo\Kpi\Data;

class RedAmberGreenRange
{
	private $data = array();


	/**
	 * This represents the state label to be used with this RAG range.
	 * For example: Ok, Warning, Critical
	 */
	public function getState()
	{
		return $this->data['state'];
	}
	public function setState($state)
	{
		$this->data['state'] = $state;
	}


	/**
	 * This represents which colour should be used. This should be in either Hex format
	 * (e.g. #FFFFFF), RGB (e.g. rgb(0,0,0)) or RGBA (e.g. rgba(0,0,0,0.5)
	 * Note: this property will be added directly to the CSS background
	 * color property, so it must be a valid value.
	 */
	public function getColour()
	{
		return $this->data['colour'];
	}
	public function setColour($colour)
	{
		$this->data['colour'] = $colour;
	}


	/**
	 * This represents the upper value up until which this colour
	 * should be applied. Note that this will rely on other
	 * RedAmberGreenData to determine from where this colour
	 * should start.
	 */
	public function getUpTo()
	{
		return $this->data['upTo'];
	}
	public function setUpTo($upto)
	{
		$this->data['upTo'] = $upto;
	}


	/**
	 * Returns the current model as an array ready to
	 * be json_encoded
	 */
	public function getJsonArray()
	{
		return $this->data;
	}
}
