<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class encapsulates data related to a KPIs RAG status.
 */

declare(strict_types=1);

namespace Mambo\Kpi\Data;

class RedAmberGreen
{
	private $data = array();


	/**
	 * This determines which units of measure to use.
	 * Possible values: percentage, point, none
	 */
	public function getUnitsOfMeasure()
	{
		return $this->data['unitsOfMeasure'];
	}
	public function setUnitsOfMeasure($unitsOfMeasure)
	{
		$this->data['unitsOfMeasure'] = $unitsOfMeasure;
	}


	/**
	 * This represents the minimum percentage value to use in the RAG ranges.
	 * For example: 0%
	 */
	public function getMinPercent()
	{
		return $this->data['minPercent'];
	}
	public function setMinPercent($minPercent)
	{
		$this->data['minPercent'] = $minPercent;
	}


	/**
	 * This represents the maximum percentage value to use in the RAG ranges.
	 * For example: 100%
	 */
	public function getMaxPercent()
	{
		return $this->data['maxPercent'];
	}
	public function setMaxPercent($maxPercent)
	{
		$this->data['maxPercent'] = $maxPercent;
	}

	/**
	 * Defines the different ranges to be used when generating the KPI's RAG progress bar
	 */
	public function getRanges()
	{
		return $this->data['ranges'];
	}
	public function setRanges(array $ranges)
	{
		$this->data['ranges'] = $ranges;
	}
	public function addRanges(RedAmberGreenRange $range)
	{
		if (!isset($this->data['ranges'])) {
			$this->data['ranges'] = array();
		}
		array_push($this->data['ranges'], $range);
	}


	/**
	 * Returns the current model as an array ready to
	 * be json_encoded
	 */
	public function getJsonArray()
	{
		$json = $this->data;

		if (isset($json['ranges'])) {
			$rangesArr = array();
			foreach ($json['ranges'] as $range) {
				array_push($rangesArr, $range->getJsonArray());
			}
			$json['ranges'] = $rangesArr;
		}

		return $json;
	}
}
