<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Provides access to the Mambo credentials used for accessing Mambo services:
 * public and private keys. These credentials are used to securely sign requests
 * to the Mambo services.
 */

declare(strict_types=1);

namespace Mambo\Http;

class MamboCredentials
{
    private $publicKey = null;
    private $privateKey = null;

    public function __construct(string $publicKey, string $privateKey)
    {
        $this->publicKey = $publicKey;
        $this->privateKey = $privateKey;
    }

    public function getPublicKey(): ?string
    {
        return $this->publicKey;
    }
    public function getPrivateKey(): ?string
    {
        return $this->privateKey;
    }
}
