<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\DataStore\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for deleting data stores by criteria
 * @extends AbstractServiceParams<DataStoreDeleteByCriteriaParams>
 */
class DataStoreDeleteByCriteriaParams extends AbstractServiceParams
{

    /**
     * @param string $type The type of data stores to delete
     * @return self
     */
    public function type(string $type): self
    {
        return $this->extraParams('type', $type);
    }

    /**
     * @param array<string> $ownedByIds The ownedBy IDs by which to delete the data stores
     * @return self
     */
    public function ownedByIds(array $ownedByIds): self
    {
        return $this->extraParamsList('ownedByIds', $ownedByIds);
    }

    /**
     * @param array<string> $ownedByUuids The ownedBy UUIDs by which to delete the data stores
     * @return self
     */
    public function ownedByUuids(array $ownedByUuids): self
    {
        return $this->extraParamsList('ownedByUuids', $ownedByUuids);
    }

    /**
     * @param string $startDate Specifies the start date from which to delete data stores
     * @return self
     */
    public function startDate(string $startDate): self
    {
        return $this->extraParams('startDate', $startDate);
    }

    /**
     * @param string $endDate Specifies the end date until which to delete data stores
     * @return self
     */
    public function endDate(string $endDate): self
    {
        return $this->extraParams('endDate', $endDate);
    }

    /**
     * @param bool $includeSystemDataStores Specifies whether to include system data stores
     * @return self
     */
    public function includeSystemDataStores(bool $includeSystemDataStores): self
    {
        return $this->extraParams('includeSystemDataStores', (string)$includeSystemDataStores);
    }
}
