<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This object captures the data required by the Coupon API in
 * order to validate a coupon.
 */

declare(strict_types=1);

namespace Mambo\Coupon\Data;

use Mambo\Common\Data\RequestData;

class CouponUserRequestData implements RequestData
{
	private $uuid;
	private $couponCode;
	private $couponId;

	/**
	 * The Unique User ID of the Player against which to validate
	 * the coupon code.
	 */
	public function getUuid()
	{
		return $this->uuid;
	}
	public function setUuid($uuid)
	{
		$this->uuid = $uuid;
	}

	/**
	 * The coupon code to validate against the specified user.
	 * If a couponId is set, this field is ignored.
	 */
	public function getCouponCode()
	{
		return $this->couponCode;
	}
	public function setCouponCode($couponCode)
	{
		$this->couponCode = $couponCode;
	}

	/**
	 * The id of the coupon to validate against the specified user.
	 * If this field is set, the couponCode field is ignored
	 */
	public function getCouponId()
	{
		return $this->couponId;
	}
	public function setCouponId($couponId)
	{
		$this->couponId = $couponId;
	}

	/**
	 * Return the JSON string equivalent of this object
	 */
	public function getJsonString(): string
	{
		return json_encode(array(
			'uuid' => $this->uuid,
			'couponId' => $this->couponId,
			'code' => $this->couponCode
		));
	}
}
