<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This object captures the data related to criteria to buy a Coupon with points.
 */

declare(strict_types=1);

namespace Mambo\Coupon\Data;

use Mambo\Common\Data\PointStore;

class BuyCriteria
{
	private $data = array();

	/**
	 * The number of points required in order to buy this coupon.
	 */
	public function getPointsToBuy()
	{
		return $this->data['pointsToBuy'];
	}
	public function setPointsToBuy(PointStore $pointsToBuy)
	{
		$this->data['pointsToBuy'] = $pointsToBuy;
	}

	/**
	 * The Buy Redemption Mode to use with this coupon.
	 */
	public function getBuyRedemptionMode()
	{
		return $this->data['buyRedemptionMode'];
	}
	public function setBuyRedemptionMode($buyRedemptionMode)
	{
		$this->data['buyRedemptionMode'] = $buyRedemptionMode;
	}

	/**
	 * Returns the current model as an array ready to
	 * be json_encoded
	 */
	public function getJsonArray()
	{
		$json = $this->data;

		if (isset($json['pointsToBuy'])) {
			$json['pointsToBuy'] = $json['pointsToBuy']->getJsonArray();
		}

		return $json;
	}
}
