<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This class encapsulates data related to a custom field.
 */

declare(strict_types=1);

namespace Mambo\Common\Data;

class CustomFieldValue implements RequestData
{
	private $data = array();


	/**
	 * The name of the custom field.
	 */
	public function getName()
	{
		return $this->data['name'];
	}
	public function setName($name)
	{
		$this->data['name'] = $name;
	}


	/**
	 * The value of the custom field.
	 */
	public function getValue()
	{
		return $this->data['value'];
	}
	public function setValue($value)
	{
		$this->data['value'] = $value;
	}


	/**
	 * Returns the current model as an array ready to
	 * be json_encoded. This is used by the
	 * CustomFieldValueRequestData
	 */
	public function getJsonArray()
	{
		return $this->data;
	}


	/**
	 * Returns the current model as an array ready to
	 * be json_encoded. This is called directly by the
	 * services class when we don't wrap the CustomFieldValue
	 * in a CustomFieldValueRequestData which is the case
	 * when we upload images.
	 */
	public function getJsonString(): string
	{
		return json_encode($this->getJsonArray());
	}
}
