<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This object captures the data required by the Behaviour API in
 * order to create / update flexible behaviours
 */

declare(strict_types=1);

namespace Mambo\Behaviour\Data;

class FlexibleAttrs
{
	private $data = array();

	/**
	 * The type of attribute
	 */
	public function getType()
	{
		return 'flexible';
	}

	/**
	 * The ID of the underlying simple behaviour
	 */
	public function getBehaviourId()
	{
		return $this->data['behaviourId'];
	}
	public function setBehaviourId($behaviourId)
	{
		$this->data['behaviourId'] = (string) $behaviourId;
	}

	/**
	 * The metadata associated to the flexible behaviour. This is an array of
	 * key/value pairs, for example: if the name of the metadata is "type" and the value is
	 * "product" then the metadata array would look like this:
	 * array( "type" => "product" )
	 * See the flexible behaviour page in the administration panel for more information.
	 */
	public function getMetadata()
	{
		return $this->data['metadata'];
	}
	public function setMetadata(MetadataCondition $metadata)
	{
		$this->data['metadata'] = $metadata;
	}


	/**
	 * Return the JSON string equivalent of this object
	 */
	public function getJsonArray()
	{
		$json = $this->data;
		$json['type'] = $this->getType();

		if (isset($json['metadata'])) {
			$json['metadata'] = $json['metadata']->getJsonArray();
		}

		return $json;
	}
}
