<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare(strict_types=1);

namespace Mambo\Analytics\Param;

use Mambo\Common\Param\AbstractServiceParams;

/**
 * Parameters for retrieving analytics data
 * @extends AbstractServiceParams<self>
 */
class AnalyticsGetListParams extends AbstractServiceParams
{
    /**
     * Specifies the page of results to retrieve
     *
     * @param int $page
     * @return self
     */
    public function page(int $page): self
    {
        return $this->extraParams('page', $page);
    }

    /**
     * Specifies the number of results to retrieve, up to a maximum of 100
     *
     * @param int $count
     * @return self
     */
    public function count(int $count): self
    {
        return $this->extraParams('count', $count);
    }

    /**
     * Specifies the type of analytics data to return
     *
     * @param string $dataType
     * @return self
     */
    public function dataType(string $dataType): self
    {
        return $this->extraParams('dataType', $dataType);
    }

    /**
     * Specifies the analytics report type to return
     *
     * @param string $reportType
     * @return self
     */
    public function reportType(string $reportType): self
    {
        return $this->extraParams('reportType', $reportType);
    }

    /**
     * Specifies the start date of the date range filter in ISO 8601 format
     *
     * @param string $startDate
     * @return self
     */
    public function startDate(string $startDate): self
    {
        return $this->extraParams('startDate', $startDate);
    }

    /**
     * Specifies the end date of the date range filter in ISO 8601 format
     *
     * @param string $endDate
     * @return self
     */
    public function endDate(string $endDate): self
    {
        return $this->extraParams('endDate', $endDate);
    }

    /**
     * Specifies the tag by which to filter the analytics
     *
     * @param string $tag
     * @return self
     */
    public function tag(string $tag): self
    {
        return $this->extraParams('tag', $tag);
    }
}
