<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * The MamboAnalyticsService class handles all Analytic related requests
 * to the Mambo API.
 */

declare(strict_types=1);

namespace Mambo\Analytics;

use Mambo\Analytics\Param\AnalyticsGetListParams;
use Mambo\Common\Service\AbstractService;
use Mambo\Http\ApiUrlBuilder;
use Mambo\Http\RequestOptions;

class AnalyticsService extends AbstractService
{
	/**
	 * Analytic service end point URI
	 * @var string
	 */
	const ANALYTICS_SITE_URI = "/v1/{site}/analytics";

	/**
	 * Get the list of analytics for the specified site.
	 *
	 * @param string $siteUrl					The site for which to retrieve the list of analytics
	 * @param AnalyticsGetListParams $params	The query parameters to be used with the request
	 * @param RequestOptions $requestOptions	The requestOptions to be used with the request
	 */
	public function getAnalytics(
		string $siteUrl,
		AnalyticsGetListParams $params = null,
		RequestOptions $requestOptions = null
	): array|object {

		$urlBuilder = new ApiUrlBuilder(self::ANALYTICS_SITE_URI);
		$urlBuilder->withPathSite($siteUrl);
		$urlBuilder->withQueryParams($params);

		return $this->httpGet($urlBuilder, $requestOptions);
	}
}
