<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Defines activity attributes specific to point.
 */

declare(strict_types=1);

namespace Mambo\Activity\Data;

use Mambo\Common\Data\PointStore;

class ActivityPointAttrs
{
	private $data = array();

	/**
	 * The type of attribute
	 */
	public function getType()
	{
		return 'point';
	}

	/**
	 * The action associated to the point activity. The actions currently
	 * available are:
	 * Increment: increments the user's total points and point balance
	 * Set: sets the user's total points and updates the point balance
	 * Redeem: decrements the user's points balance and increments the user's spent points
	 * Refund: decrements the user's spent points and increments the user's point balance
	 */
	public function getAction()
	{
		return $this->data['action'];
	}
	public function setAction($action)
	{
		$this->data['action'] = (string) $action;
	}

	/**
	 * The points associated with this point activity.
	 */
	public function getPoints()
	{
		return $this->data['points'];
	}
	public function setPoints(array $points)
	{
		$this->data['points'] = $points;
	}
	public function addPoint(PointStore $point)
	{
		if (!isset($this->data['points'])) {
			$this->data['points'] = array();
		}
		array_push($this->data['points'], $point);
	}


	/**
	 * Return the JSON string equivalent of this object
	 */
	public function getJsonArray()
	{
		$json = $this->data;
		$json['type'] = $this->getType();

		if (isset($json['points'])) {
			$pointsArr = array();
			foreach ($json['points'] as $point) {
				array_push($pointsArr, $point->getJsonArray());
			}
			$json['points'] = $pointsArr;
		}

		return $json;
	}
}
