<?php
/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Import all the relevant Mambo PHP SDK files.
 */

// Client
require_once __DIR__ . '/sdk/ClientConfiguration.php';
require_once __DIR__ . '/sdk/MamboClient.php';

// Exceptions
require_once __DIR__ . '/sdk/Exception/MamboException.php';
require_once __DIR__ . '/sdk/Exception/MamboApiException.php';
require_once __DIR__ . '/sdk/Exception/ParameterError.php';
require_once __DIR__ . '/sdk/Exception/MamboError.php';
require_once __DIR__ . '/sdk/Exception/ApiConnectionException.php';
require_once __DIR__ . '/sdk/Exception/JsonProcessingException.php';
require_once __DIR__ . '/sdk/Exception/AuthenticationException.php';
require_once __DIR__ . '/sdk/Exception/IdempotencyException.php';
require_once __DIR__ . '/sdk/Exception/OAuth/OAuthError.php';
require_once __DIR__ . '/sdk/Exception/OAuth/OAuthException.php';
require_once __DIR__ . '/sdk/Exception/OAuth/InvalidRequestException.php';
require_once __DIR__ . '/sdk/Exception/OAuth/InvalidTokenException.php';
require_once __DIR__ . '/sdk/Exception/OAuth/UnsupportedGrantTypeException.php';
require_once __DIR__ . '/sdk/Exception/MamboExceptionFactory.php';

// HTTP Client
require_once __DIR__ . '/sdk/Http/ApiUrlBuilder.php';
require_once __DIR__ . '/sdk/Http/HttpClient.php';
require_once __DIR__ . '/sdk/Http/MamboCredentials.php';
require_once __DIR__ . '/sdk/Http/RequestOptions.php';

// JSON
require_once __DIR__ . '/sdk/Json/JsonMapper.php';

// Services
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Recurrence.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/NeverRecurrence.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/FixedDateRecurrence.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/FixedPeriodRecurrence.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/VariablePeriodRecurrence.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/VariablePeriod.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/FixedPeriod.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/FixedPeriodHourly.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/FixedPeriodDaily.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/FixedPeriodWeekly.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/FixedPeriodMonthly.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/FixedPeriodYearly.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/Criteria/FixedPeriodCriteria.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/Criteria/FixedPeriodCriteriaDaysOfMonth.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/Criteria/FixedPeriodCriteriaWeeksOfMonth.php';
require_once __DIR__ . '/sdk/Common/Data/Recurrence/Period/Criteria/FixedPeriodCriteriaWeeksOfYear.php';
require_once __DIR__ . '/sdk/Common/Data/RequestData.php';
require_once __DIR__ . '/sdk/Common/Data/AbstractHasTagRequestData.php';
require_once __DIR__ . '/sdk/Common/Data/AbstractTranslation.php';
require_once __DIR__ . '/sdk/Common/Data/CustomFieldValue.php';
require_once __DIR__ . '/sdk/Common/Data/CustomFieldValueRequestData.php';
require_once __DIR__ . '/sdk/Common/Data/DeleteRequestData.php';
require_once __DIR__ . '/sdk/Common/Data/PointStore.php';
require_once __DIR__ . '/sdk/Common/Data/Prize.php';
require_once __DIR__ . '/sdk/Common/Data/PrizeTags.php';
require_once __DIR__ . '/sdk/Common/Data/Scarcity.php';
require_once __DIR__ . '/sdk/Common/Param/ServiceParams.php';
require_once __DIR__ . '/sdk/Common/Param/AbstractServiceParams.php';
require_once __DIR__ . '/sdk/Common/Service/AbstractService.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityBehaviourAttrs.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityBountyAttrs.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityCouponAttrs.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityGiftedAttrs.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityKpiAttrs.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityPointAttrs.php';
require_once __DIR__ . '/sdk/Activity/Data/ActivityRequestData.php';
require_once __DIR__ . '/sdk/Activity/Data/Content.php';
require_once __DIR__ . '/sdk/Activity/Data/RejectActivityCriteriaRequestData.php';
require_once __DIR__ . '/sdk/Activity/Data/RejectActivityRequestData.php';
require_once __DIR__ . '/sdk/Activity/Param/ActivityGetListByUserParams.php';
require_once __DIR__ . '/sdk/Activity/Param/ActivityGetListParams.php';
require_once __DIR__ . '/sdk/Activity/ActivitiesService.php';
require_once __DIR__ . '/sdk/Analytics/Param/AnalyticsGetListParams.php';
require_once __DIR__ . '/sdk/Analytics/AnalyticsService.php';
require_once __DIR__ . '/sdk/Behaviour/Data/ActivityStream.php';
require_once __DIR__ . '/sdk/Behaviour/Data/MetadataCondition.php';
require_once __DIR__ . '/sdk/Behaviour/Data/AndMetadataCondition.php';
require_once __DIR__ . '/sdk/Behaviour/Data/BehaviourRequestData.php';
require_once __DIR__ . '/sdk/Behaviour/Data/BehaviourTranslation.php';
require_once __DIR__ . '/sdk/Behaviour/Data/FlexibleAttrs.php';
require_once __DIR__ . '/sdk/Behaviour/Data/LeafMetadataCondition.php';
require_once __DIR__ . '/sdk/Behaviour/Data/Limit.php';
require_once __DIR__ . '/sdk/Behaviour/Data/OrMetadataCondition.php';
require_once __DIR__ . '/sdk/Behaviour/Data/SimpleAttrs.php';
require_once __DIR__ . '/sdk/Behaviour/Param/BehaviourGetFlexibleListParams.php';
require_once __DIR__ . '/sdk/Behaviour/Param/BehaviourGetListParams.php';
require_once __DIR__ . '/sdk/Behaviour/Param/BehaviourGetSimpleListParams.php';
require_once __DIR__ . '/sdk/Behaviour/BehavioursService.php';
require_once __DIR__ . '/sdk/Coupon/Data/BuyCriteria.php';
require_once __DIR__ . '/sdk/Coupon/Data/CouponRequestData.php';
require_once __DIR__ . '/sdk/Coupon/Data/CouponTranslation.php';
require_once __DIR__ . '/sdk/Coupon/Data/CouponUserRequestData.php';
require_once __DIR__ . '/sdk/Coupon/Data/CouponCode.php';
require_once __DIR__ . '/sdk/Coupon/Data/MultipleCouponCode.php';
require_once __DIR__ . '/sdk/Coupon/Data/SingleCouponCode.php';
require_once __DIR__ . '/sdk/Coupon/Param/CouponGetBuyableListParams.php';
require_once __DIR__ . '/sdk/Coupon/Param/CouponGetListParams.php';
require_once __DIR__ . '/sdk/Coupon/Param/CouponGetRegularListParams.php';
require_once __DIR__ . '/sdk/Coupon/Param/CouponGetStateListParams.php';
require_once __DIR__ . '/sdk/Coupon/CouponsService.php';
require_once __DIR__ . '/sdk/Customfield/Data/CustomFieldRequestData.php';
require_once __DIR__ . '/sdk/Customfield/CustomFieldsService.php';
require_once __DIR__ . '/sdk/Datastore/Data/DataStoreRequestData.php';
require_once __DIR__ . '/sdk/Datastore/Param/DataStoreDeleteByCriteriaParams.php';
require_once __DIR__ . '/sdk/Datastore/Param/DataStoreGetListParams.php';
require_once __DIR__ . '/sdk/Datastore/Param/DataStoreGetParams.php';
require_once __DIR__ . '/sdk/Datastore/DataStoresService.php';
require_once __DIR__ . '/sdk/Kpi/Data/KpiPrize.php';
require_once __DIR__ . '/sdk/Kpi/Data/KpiRequestData.php';
require_once __DIR__ . '/sdk/Kpi/Data/KpiTargetRequestData.php';
require_once __DIR__ . '/sdk/Kpi/Data/KpiTranslation.php';
require_once __DIR__ . '/sdk/Kpi/Data/RedAmberGreen.php';
require_once __DIR__ . '/sdk/Kpi/Data/RedAmberGreenRange.php';
require_once __DIR__ . '/sdk/Kpi/Data/Tracked.php';
require_once __DIR__ . '/sdk/Kpi/Param/KpiGetListParams.php';
require_once __DIR__ . '/sdk/Kpi/Param/KpiGetStatesParams.php';
require_once __DIR__ . '/sdk/Kpi/KpisService.php';
require_once __DIR__ . '/sdk/Language/Data/LanguageRequestData.php';
require_once __DIR__ . '/sdk/Language/LanguagesService.php';
require_once __DIR__ . '/sdk/Leaderboard/Data/LeaderboardBehaviourAttrs.php';
require_once __DIR__ . '/sdk/Leaderboard/Data/LeaderboardPointAttrs.php';
require_once __DIR__ . '/sdk/Leaderboard/Data/LeaderboardRequestData.php';
require_once __DIR__ . '/sdk/Leaderboard/Data/LeaderboardTranslation.php';
require_once __DIR__ . '/sdk/Leaderboard/Param/LeaderboardGetListParams.php';
require_once __DIR__ . '/sdk/Leaderboard/Param/LeaderboardGetParams.php';
require_once __DIR__ . '/sdk/Leaderboard/LeaderboardsService.php';
require_once __DIR__ . '/sdk/Notification/Data/ClearNotificationsRequestData.php';
require_once __DIR__ . '/sdk/Notification/Param/NotificationGetByActivityIdParams.php';
require_once __DIR__ . '/sdk/Notification/Param/NotificationGetListParams.php';
require_once __DIR__ . '/sdk/Notification/Param/NotificationGetParams.php';
require_once __DIR__ . '/sdk/Notification/NotificationsService.php';
require_once __DIR__ . '/sdk/Point/Data/Decimals.php';
require_once __DIR__ . '/sdk/Point/Data/PointRequestData.php';
require_once __DIR__ . '/sdk/Point/Data/PointTranslation.php';
require_once __DIR__ . '/sdk/Point/Data/Units.php';
require_once __DIR__ . '/sdk/Point/Param/PointGetListParams.php';
require_once __DIR__ . '/sdk/Point/PointsService.php';
require_once __DIR__ . '/sdk/Reward/Data/AchievementAttrs.php';
require_once __DIR__ . '/sdk/Reward/Data/GiftAttrs.php';
require_once __DIR__ . '/sdk/Reward/Data/LevelAttrs.php';
require_once __DIR__ . '/sdk/Reward/Data/MissionAttrs.php';
require_once __DIR__ . '/sdk/Reward/Data/RewardRequestData.php';
require_once __DIR__ . '/sdk/Reward/Data/RewardTranslation.php';
require_once __DIR__ . '/sdk/Reward/Data/UnlockCondition.php';
require_once __DIR__ . '/sdk/Reward/Param/RewardGetAchievementListParams.php';
require_once __DIR__ . '/sdk/Reward/Param/RewardGetGiftListParams.php';
require_once __DIR__ . '/sdk/Reward/Param/RewardGetLevelListParams.php';
require_once __DIR__ . '/sdk/Reward/Param/RewardGetListParams.php';
require_once __DIR__ . '/sdk/Reward/Param/RewardGetMissionListParams.php';
require_once __DIR__ . '/sdk/Reward/RewardsService.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/AuthenticationContextDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/AuthenticationRedirectDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/AuthenticationType.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/DatabaseAuthenticationContextDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/JwtAuthenticationContextDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/LdapAuthenticationContextDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/LdapSyncUserAttributesDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/NoAuthAuthenticationContextDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/SamlAuthenticationContextDto.php';
require_once __DIR__ . '/sdk/Site/Data/Authentication/SamlSyncUserAttributesDto.php';
require_once __DIR__ . '/sdk/Site/Data/ActivitiesJavaScriptSecurity.php';
require_once __DIR__ . '/sdk/Site/Data/Security.php';
require_once __DIR__ . '/sdk/Site/Data/SiteRequestData.php';
require_once __DIR__ . '/sdk/Site/Data/UsersJavaScriptSecurity.php';
require_once __DIR__ . '/sdk/Site/SitesService.php';
require_once __DIR__ . '/sdk/Tag/Data/TagRequestData.php';
require_once __DIR__ . '/sdk/Tag/Data/TagTranslation.php';
require_once __DIR__ . '/sdk/Tag/TagsService.php';
require_once __DIR__ . '/sdk/User/Data/UserDetails.php';
require_once __DIR__ . '/sdk/User/Data/UserRequestData.php';
require_once __DIR__ . '/sdk/User/Param/UserBlacklistGetListParams.php';
require_once __DIR__ . '/sdk/User/Param/UserCreateParams.php';
require_once __DIR__ . '/sdk/User/Param/UserCustomFieldParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAchievementsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetActivitiesParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAllAchievementsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAllCouponsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAllGiftsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAllLevelsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAllMissionsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetAllRewardsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetByIdParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetCouponsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetGiftsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetKpisParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetLeaderboardParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetLevelsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetListParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetMissionsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetNotificationsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetPointTransactionsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetPointWalletsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserGetRewardsParams.php';
require_once __DIR__ . '/sdk/User/Param/UserSearchParams.php';
require_once __DIR__ . '/sdk/User/Param/UserUpdateParams.php';
require_once __DIR__ . '/sdk/User/Param/UserUploadParams.php';
require_once __DIR__ . '/sdk/User/UsersService.php';
require_once __DIR__ . '/sdk/Webhook/Data/WebhookRequestData.php';
require_once __DIR__ . '/sdk/Webhook/Param/WebhookGetListParams.php';
require_once __DIR__ . '/sdk/Webhook/WebhooksService.php';
