/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.utils;

import io.mambo.sdk.exception.MamboException;
import io.mambo.sdk.utils.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class StreamUtils {
    private static final int BUFFER_SIZE = 4096;

    private StreamUtils() {
    }

    public static String toString(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream, "inputStream must not be null");
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = StreamUtils.toBufferedReader(inputStream);){
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, bytesRead);
            }
        }
        return stringBuilder.toString();
    }

    private static BufferedReader toBufferedReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static InputStream toInputStream(File file) {
        try {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new MamboException("Error converting file to input stream", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream source, OutputStream destination) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytesRead);
            }
            destination.flush();
        }
        finally {
            source.close();
        }
    }
}

