/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.utils;

import io.mambo.sdk.utils.MapUtils;
import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;

public class NumberConverter {
    private final Double number;

    public NumberConverter(Number number) {
        this.number = number.doubleValue();
    }

    public static Map<String, NumberConverter> toNumberConverter(Map<String, Number> map) {
        if (MapUtils.isEmpty(map)) {
            return MapUtils.newHashMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new NumberConverter((Number)entry.getValue())));
    }

    public boolean hasDecimals() {
        return this.number % 1.0 != 0.0;
    }

    public Long longValue() {
        return this.number.longValue();
    }

    public Double doubleValue() {
        return this.number;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.number);
    }
}

