/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.utils;

import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.MapUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class Multimap<K, V> {
    private Map<K, List<V>> map;

    public Multimap() {
        this.map = MapUtils.newHashMap();
    }

    private Multimap(Map<K, List<V>> map) {
        this.map = map;
    }

    private Multimap(Multimap<K, V> other) {
        this.map = MapUtils.newHashMap();
        this.putAll(other);
    }

    public static <K, V> Multimap<K, V> of(Map<K, List<V>> map) {
        return new Multimap<K, V>(map);
    }

    public static <K, V> Multimap<K, V> of(Multimap<K, V> map) {
        return new Multimap<K, V>(map);
    }

    public void put(K key, V value) {
        this.map.computeIfAbsent(key, k -> ListUtils.newArrayList()).add(value);
    }

    public void putAll(Multimap<K, V> other) {
        other.map.forEach((key, values) -> values.forEach(value -> this.put(key, value)));
    }

    public void putAll(K key, List<V> values) {
        values.forEach(value -> this.put(key, value));
    }

    public List<V> get(K key) {
        return this.map.getOrDefault(key, ListUtils.newArrayList());
    }

    public V getFirst(K key) {
        List<V> values = this.get(key);
        return values.isEmpty() ? null : (V)values.get(0);
    }

    public boolean remove(K key, V value) {
        List<V> values = this.map.get(key);
        if (values != null) {
            boolean removed = values.remove(value);
            if (values.isEmpty()) {
                this.map.remove(key);
            }
            return removed;
        }
        return false;
    }

    public List<V> removeAll(K key) {
        return this.map.remove(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.map.values().stream().anyMatch(values -> values.contains(value));
    }

    public boolean containsEntry(K key, V value) {
        List<V> values = this.map.get(key);
        return values != null && values.contains(value);
    }

    public int size() {
        return this.map.values().stream().mapToInt(List::size).sum();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        ArrayList allValues = new ArrayList();
        this.map.values().forEach(allValues::addAll);
        return allValues;
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Generated
    public String toString() {
        return "Multimap(map=" + this.map + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Multimap)) {
            return false;
        }
        Multimap other = (Multimap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<K, List<V>> this$map = this.map;
        Map<K, List<V>> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Multimap;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, List<V>> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }
}

