/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    private ListUtils() {
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !ListUtils.isEmpty(coll);
    }

    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <E> List<E> of(E ... elements) {
        return ListUtils.newArrayList(elements);
    }

    @SafeVarargs
    public static <E> List<E> newArrayList(E ... elements) {
        List<E> list = ListUtils.newArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> E getLast(List<E> list) {
        if (ListUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }
}

