/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.mambo.sdk.exception.JsonProcessingException;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.common.model.response.ResponseEntity;
import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonUtils {
    private static ObjectMapper mapper = JsonUtils.buildMapper();

    private JsonUtils() {
    }

    private static ObjectMapper buildMapper() {
        if (mapper != null) {
            return mapper;
        }
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("removeUninitialized", (SimpleBeanPropertyFilter)new HasInitializedPropertyFilter());
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).filterProvider((FilterProvider)filterProvider)).build();
    }

    public static ObjectMapper objectMapper() {
        return mapper;
    }

    public static String serialize(Object toSerialise) {
        try {
            return mapper.writeValueAsString(toSerialise);
        }
        catch (Exception exception) {
            throw new JsonProcessingException("There was a problem serializing the response", toSerialise, exception);
        }
    }

    public static <T> T deserialize(String jsonString, Class<?> classType) {
        JavaType type = mapper.getTypeFactory().constructType(classType);
        return JsonUtils.deserializeAsJavaType(jsonString, type);
    }

    private static <T> T deserializeAsJavaType(String jsonString, JavaType type) {
        try {
            return (T)mapper.readValue(jsonString, type);
        }
        catch (Exception exception) {
            throw new JsonProcessingException("There was a problem deserializing the response", jsonString, exception);
        }
    }

    public static <T> T deserialize(String jsonString, Class<?> classType, ResponseType responseType) {
        if (responseType.isObject()) {
            return JsonUtils.deserialize(jsonString, classType);
        }
        if (responseType.isList()) {
            return JsonUtils.deserializeList(jsonString, classType);
        }
        return JsonUtils.deserializeResponseEntity(jsonString, classType);
    }

    private static <T> T deserializeList(String jsonString, Class<?> classType) {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, classType);
        return JsonUtils.deserializeAsJavaType(jsonString, (JavaType)type);
    }

    private static <T> T deserializeResponseEntity(String jsonString, Class<?> classType) {
        JavaType type = mapper.getTypeFactory().constructParametricType(ResponseEntity.class, new Class[]{classType});
        return JsonUtils.deserializeAsJavaType(jsonString, type);
    }

    private static class HasInitializedPropertyFilter
    extends SimpleBeanPropertyFilter {
        private ThreadLocal<Set<String>> propertiesToInclude = new ThreadLocal();

        private HasInitializedPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            String lowerCaseProp = StringUtils.lowerCase(writer.getName());
            return this.propertiesToInclude.get().contains(lowerCaseProp);
        }

        protected boolean include(PropertyWriter writer) {
            String lowerCaseProp = StringUtils.lowerCase(writer.getName());
            return this.propertiesToInclude.get().contains(lowerCaseProp);
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            this.propertiesToInclude.remove();
            this.propertiesToInclude.set(new HashSet());
            if (!HasInitializedData.class.isAssignableFrom(pojo.getClass())) {
                super.serializeAsField(pojo, jgen, provider, writer);
                return;
            }
            HasInitializedData data = (HasInitializedData)pojo;
            if (ListUtils.isEmpty(data.getInitializedFields())) {
                super.serializeAsField(pojo, jgen, provider, writer);
                return;
            }
            List lowerCasePropertiesToInclude = data.getInitializedFields().stream().map(StringUtils::lowerCase).collect(Collectors.toCollection(ArrayList::new));
            this.propertiesToInclude.get().addAll(lowerCasePropertiesToInclude);
            super.serializeAsField(pojo, jgen, provider, writer);
        }
    }
}

