/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.webhook.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;

public class WebhookUpdateParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();
    private static final String WEBHOOK_ID_MUST_NOT_BE_NULL = "webhookId must not be null";

    private WebhookUpdateParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        public Builder webhookId(String webhookId) {
            Preconditions.checkNotNull(webhookId, WebhookUpdateParams.WEBHOOK_ID_MUST_NOT_BE_NULL);
            this.params.put("webhookId", webhookId);
            return this;
        }

        public WebhookUpdateParams build() {
            Preconditions.checkContainsKey(this.params, "webhookId", WebhookUpdateParams.WEBHOOK_ID_MUST_NOT_BE_NULL);
            return new WebhookUpdateParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

