/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.webhook;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.model.response.ResponseEntity;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.webhook.data.WebhookRequestData;
import io.mambo.sdk.service.webhook.model.WebhookDto;
import io.mambo.sdk.service.webhook.param.WebhookDeleteParams;
import io.mambo.sdk.service.webhook.param.WebhookGetListParams;
import io.mambo.sdk.service.webhook.param.WebhookGetParams;
import io.mambo.sdk.service.webhook.param.WebhookUpdateParams;

public class WebhooksService
extends AbstractService {
    private static final String WEBHOOKS_URI = "/v1/webhooks";
    private static final String WEBHOOKS_ID_URI = "/v1/webhooks/{webhookId}";

    public WebhooksService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public WebhookDto create(WebhookRequestData data) {
        return this.create(data, RequestOptions.create());
    }

    public WebhookDto create(WebhookRequestData data, RequestOptions requestOptions) {
        return (WebhookDto)this.apiClient().request(ApiRequest.builder().apiPath(WEBHOOKS_URI).responseClass(WebhookDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).build());
    }

    public WebhookDto update(String webhookId, WebhookRequestData data) {
        return this.update(WebhookUpdateParams.builder().webhookId(webhookId).build(), data);
    }

    public WebhookDto update(WebhookUpdateParams params, WebhookRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public WebhookDto update(WebhookUpdateParams params, WebhookRequestData data, RequestOptions requestOptions) {
        return (WebhookDto)this.apiClient().request(ApiRequest.builder().apiPath(WEBHOOKS_ID_URI).responseClass(WebhookDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public Status delete(String webhookId) {
        return this.delete(WebhookDeleteParams.builder().webhookId(webhookId).build());
    }

    public Status delete(WebhookDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(WebhookDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(WEBHOOKS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public WebhookDto get(String webhookId) {
        return this.get(WebhookGetParams.builder().webhookId(webhookId).build());
    }

    public WebhookDto get(WebhookGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public WebhookDto get(WebhookGetParams params, RequestOptions requestOptions) {
        return (WebhookDto)this.apiClient().request(ApiRequest.builder().apiPath(WEBHOOKS_ID_URI).responseClass(WebhookDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteWebhooks(DeleteRequestData data) {
        return this.deleteWebhooks(data, RequestOptions.create());
    }

    public Status deleteWebhooks(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(WEBHOOKS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public ResponseEntity<WebhookDto> getWebhooks() {
        return this.getWebhooks(WebhookGetListParams.builder().build());
    }

    public ResponseEntity<WebhookDto> getWebhooks(WebhookGetListParams params) {
        return this.getWebhooks(params, RequestOptions.create());
    }

    public ResponseEntity<WebhookDto> getWebhooks(WebhookGetListParams params, RequestOptions requestOptions) {
        return (ResponseEntity)this.apiClient().request(ApiRequest.builder().apiPath(WEBHOOKS_URI).responseClass(WebhookDto.class).responseType(ResponseType.RESPONSE_ENTITY).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public WebhookRequestData newWebhookRequestData() {
        return new WebhookRequestData();
    }
}

