/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param.reward;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserGetRewardsParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserGetRewardsParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String UUID_MUST_NOT_BE_NULL = "uuid must not be null";
        private static final String SITE_URL_MUST_NOT_BE_NULL = "siteUrl must not be null";

        public Builder uuid(String uuid) {
            Preconditions.checkNotNull(uuid, UUID_MUST_NOT_BE_NULL);
            this.params.put("uuid", uuid);
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, SITE_URL_MUST_NOT_BE_NULL);
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder tags(List<String> tags) {
            this.params.putAll("tags", tags);
            return this;
        }

        public Builder tagsJoin(String tagsJoin) {
            this.params.put("tagsJoin", tagsJoin);
            return this;
        }

        public Builder withPersonalization(boolean withPersonalization) {
            this.params.put("withPersonalization", String.valueOf(withPersonalization));
            return this;
        }

        public UserGetRewardsParams build() {
            Preconditions.checkContainsKey(this.params, "uuid", UUID_MUST_NOT_BE_NULL);
            Preconditions.checkContainsKey(this.params, "siteUrl", SITE_URL_MUST_NOT_BE_NULL);
            return new UserGetRewardsParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

