/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param.point;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserGetPointWalletsParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserGetPointWalletsParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String UUID_MUST_NOT_BE_NULL = "uuid must not be null";
        private static final String SITE_URL_MUST_NOT_BE_NULL = "siteUrl must not be null";

        public Builder uuid(String uuid) {
            Preconditions.checkNotNull(uuid, UUID_MUST_NOT_BE_NULL);
            this.params.put("uuid", uuid);
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, SITE_URL_MUST_NOT_BE_NULL);
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.params.put("pageSize", String.valueOf(pageSize));
            return this;
        }

        public Builder pageAfter(String pageAfter) {
            this.params.put("pageAfter", pageAfter);
            return this;
        }

        public Builder pageBefore(String pageBefore) {
            this.params.put("pageBefore", pageBefore);
            return this;
        }

        public Builder expand(List<String> expand) {
            this.params.putAll("expand", expand);
            return this;
        }

        public UserGetPointWalletsParams build() {
            Preconditions.checkContainsKey(this.params, "uuid", UUID_MUST_NOT_BE_NULL);
            Preconditions.checkContainsKey(this.params, "siteUrl", SITE_URL_MUST_NOT_BE_NULL);
            return new UserGetPointWalletsParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

