/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param.leaderboard;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserGetLeaderboardParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserGetLeaderboardParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String UUID_MUST_NOT_BE_NULL = "uuid must not be null";
        private static final String SITE_URL_MUST_NOT_BE_NULL = "siteUrl must not be null";
        private static final String LEADERBOARD_ID_MUST_NOT_BE_NULL = "leaderboardId must not be null";

        public Builder uuid(String uuid) {
            Preconditions.checkNotNull(uuid, UUID_MUST_NOT_BE_NULL);
            this.params.put("uuid", uuid);
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, SITE_URL_MUST_NOT_BE_NULL);
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder leaderboardId(String leaderboardId) {
            Preconditions.checkNotNull(leaderboardId, LEADERBOARD_ID_MUST_NOT_BE_NULL);
            this.params.put("leaderboardId", leaderboardId);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder tag(String tag) {
            this.params.put("tag", tag);
            return this;
        }

        public Builder period(String period) {
            this.params.put("period", period);
            return this;
        }

        public Builder contextual(boolean contextual) {
            this.params.put("contextual", String.valueOf(contextual));
            return this;
        }

        public Builder properties(List<String> properties) {
            this.params.putAll("props", properties);
            return this;
        }

        public UserGetLeaderboardParams build() {
            Preconditions.checkContainsKey(this.params, "uuid", UUID_MUST_NOT_BE_NULL);
            Preconditions.checkContainsKey(this.params, "siteUrl", SITE_URL_MUST_NOT_BE_NULL);
            Preconditions.checkContainsKey(this.params, "leaderboardId", LEADERBOARD_ID_MUST_NOT_BE_NULL);
            return new UserGetLeaderboardParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

