/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param.activity;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserGetActivitiesParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserGetActivitiesParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String UUID_MUST_NOT_BE_NULL = "uuid must not be null";
        private static final String SITE_URL_MUST_NOT_BE_NULL = "siteUrl must not be null";

        public Builder uuid(String uuid) {
            Preconditions.checkNotNull(uuid, UUID_MUST_NOT_BE_NULL);
            this.params.put("uuid", uuid);
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, SITE_URL_MUST_NOT_BE_NULL);
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder tags(List<String> tags) {
            this.params.putAll("tags", tags);
            return this;
        }

        public Builder tagsJoin(String tagsJoin) {
            this.params.put("tagsJoin", tagsJoin);
            return this;
        }

        public Builder withPersonalization(boolean withPersonalization) {
            this.params.put("withPersonalization", String.valueOf(withPersonalization));
            return this;
        }

        public Builder withBehavioursOnly(boolean withBehavioursOnly) {
            this.params.put("withBehavioursOnly", String.valueOf(withBehavioursOnly));
            return this;
        }

        public Builder withRewardsOnly(boolean withRewardsOnly) {
            this.params.put("withRewardsOnly", String.valueOf(withRewardsOnly));
            return this;
        }

        public Builder withMissionsOnly(boolean withMissionsOnly) {
            this.params.put("withMissionsOnly", String.valueOf(withMissionsOnly));
            return this;
        }

        public Builder withLevelsOnly(boolean withLevelsOnly) {
            this.params.put("withLevelsOnly", String.valueOf(withLevelsOnly));
            return this;
        }

        public Builder withAchievementsOnly(boolean withAchievementsOnly) {
            this.params.put("withAchievementsOnly", String.valueOf(withAchievementsOnly));
            return this;
        }

        public Builder withGiftsOnly(boolean withGiftsOnly) {
            this.params.put("withGiftsOnly", String.valueOf(withGiftsOnly));
            return this;
        }

        public Builder withKPIsOnly(boolean withKPIsOnly) {
            this.params.put("withKPIsOnly", String.valueOf(withKPIsOnly));
            return this;
        }

        public Builder withCompensatedOnly(boolean withCompensatedOnly) {
            this.params.put("withCompensatedOnly", String.valueOf(withCompensatedOnly));
            return this;
        }

        public Builder withRejectedOnly(boolean withRejectedOnly) {
            this.params.put("withRejectedOnly", String.valueOf(withRejectedOnly));
            return this;
        }

        public Builder withExceptions(boolean withExceptions) {
            this.params.put("withExceptions", String.valueOf(withExceptions));
            return this;
        }

        public Builder withTargetUser(boolean withTargetUser) {
            this.params.put("withTargetUser", String.valueOf(withTargetUser));
            return this;
        }

        public Builder populated(boolean populated) {
            this.params.put("populated", String.valueOf(populated));
            return this;
        }

        public Builder startDate(String startDate) {
            this.params.put("startDate", startDate);
            return this;
        }

        public Builder endDate(String endDate) {
            this.params.put("endDate", endDate);
            return this;
        }

        @Deprecated
        public Builder pointIds(List<String> pointIds) {
            this.params.putAll("pointIds", pointIds);
            return this;
        }

        public Builder rewardIds(List<String> rewardIds) {
            this.params.putAll("rewardIds", rewardIds);
            return this;
        }

        public Builder behaviourIds(List<String> behaviourIds) {
            this.params.putAll("behaviourIds", behaviourIds);
            return this;
        }

        public Builder kpiIds(List<String> kpiIds) {
            this.params.putAll("kpiIds", kpiIds);
            return this;
        }

        public UserGetActivitiesParams build() {
            Preconditions.checkContainsKey(this.params, "uuid", UUID_MUST_NOT_BE_NULL);
            Preconditions.checkContainsKey(this.params, "siteUrl", SITE_URL_MUST_NOT_BE_NULL);
            return new UserGetActivitiesParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

