/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.Order;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.service.user.param.UserOrderBy;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserGetListParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserGetListParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String SITE_URL_MUST_NOT_BE_NULL = "siteUrl must not be null";

        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, SITE_URL_MUST_NOT_BE_NULL);
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder tags(List<String> tags) {
            this.params.putAll("tags", tags);
            return this;
        }

        public Builder tagsJoin(String tagsJoin) {
            this.params.put("tagsJoin", tagsJoin);
            return this;
        }

        public Builder orderBy(UserOrderBy orderBy) {
            this.params.put("orderBy", orderBy.value());
            return this;
        }

        public Builder order(Order order) {
            this.params.put("order", order.value());
            return this;
        }

        public Builder withStats(boolean withStats) {
            this.params.put("withStats", String.valueOf(withStats));
            return this;
        }

        public Builder properties(List<String> properties) {
            this.params.putAll("props", properties);
            return this;
        }

        public Builder rewardIds(List<String> rewardIds) {
            this.params.putAll("rewardIds", rewardIds);
            return this;
        }

        public Builder behaviourIds(List<String> behaviourIds) {
            this.params.putAll("behaviourIds", behaviourIds);
            return this;
        }

        public Builder lastSeenOnStart(String lastSeenOnStart) {
            this.params.put("lastSeenOnStart", lastSeenOnStart);
            return this;
        }

        public Builder lastSeenOnEnd(String lastSeenOnEnd) {
            this.params.put("lastSeenOnEnd", lastSeenOnEnd);
            return this;
        }

        public UserGetListParams build() {
            Preconditions.checkContainsKey(this.params, "siteUrl", SITE_URL_MUST_NOT_BE_NULL);
            return new UserGetListParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

