/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserGetByIdParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserGetByIdParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String USER_ID_MUST_NOT_BE_NULL = "userId must not be null";

        public Builder userId(String userId) {
            Preconditions.checkNotNull(userId, USER_ID_MUST_NOT_BE_NULL);
            this.params.put("userId", userId);
            return this;
        }

        public Builder withStats(boolean withStats) {
            this.params.put("withStats", String.valueOf(withStats));
            return this;
        }

        public Builder properties(List<String> properties) {
            this.params.putAll("props", properties);
            return this;
        }

        public UserGetByIdParams build() {
            Preconditions.checkContainsKey(this.params, "userId", USER_ID_MUST_NOT_BE_NULL);
            return new UserGetByIdParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

