/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class UserCreateParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private UserCreateParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String SITE_URL_MUST_NOT_BE_NULL = "siteUrl must not be null";

        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, SITE_URL_MUST_NOT_BE_NULL);
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder withPersonalization(boolean withPersonalization) {
            this.params.put("withPersonalization", String.valueOf(withPersonalization));
            return this;
        }

        public Builder properties(List<String> properties) {
            this.params.putAll("props", properties);
            return this;
        }

        public UserCreateParams build() {
            Preconditions.checkContainsKey(this.params, "siteUrl", SITE_URL_MUST_NOT_BE_NULL);
            return new UserCreateParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

