/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user.model;

import io.mambo.sdk.service.common.model.ImageDto;
import io.mambo.sdk.service.common.model.awarded.AwardedRewardDto;
import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import io.mambo.sdk.service.common.model.tag.HasTags;
import io.mambo.sdk.service.tag.model.TagDto;
import io.mambo.sdk.service.user.model.AbstractUser;
import io.mambo.sdk.service.user.model.UserPointsDto;
import io.mambo.sdk.service.user.model.UserStatsDto;
import io.mambo.sdk.utils.StringUtils;
import java.util.List;
import lombok.Generated;

public class UserDto
extends AbstractUser
implements AggregateDto,
HasTags,
HasId {
    private String id;
    private String createdOn;
    private String lastSeenOn;
    private String memberSince;
    private String lastActivityOn;
    private ImageDto image = new ImageDto();
    private List<UserPointsDto> points;
    private AwardedRewardDto level;
    private AwardedRewardDto lastReward;
    private UserStatsDto stats;
    private Boolean blacklisted;
    private List<TagDto> tags;
    private List<String> tagIds;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ImageDto getImage() {
        return this.image;
    }

    public void setImage(ImageDto image) {
        this.image = image;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getLastSeenOn() {
        return this.lastSeenOn;
    }

    public void setLastSeenOn(String lastSeenOn) {
        this.lastSeenOn = lastSeenOn;
    }

    public String getLastActivityOn() {
        return this.lastActivityOn;
    }

    public void setLastActivityOn(String lastActivityOn) {
        this.lastActivityOn = lastActivityOn;
    }

    public String getMemberSince() {
        return this.memberSince;
    }

    public void setMemberSince(String memberSince) {
        this.memberSince = memberSince;
    }

    public List<UserPointsDto> getPoints() {
        return this.points;
    }

    public void setPoints(List<UserPointsDto> points) {
        this.points = points;
    }

    public UserPointsDto getPoint(String pointId) {
        if (this.points == null) {
            return null;
        }
        for (UserPointsDto point : this.points) {
            if (!StringUtils.equals(point.getPointId(), pointId)) continue;
            return point;
        }
        return null;
    }

    public Boolean isBlacklisted() {
        return this.blacklisted;
    }

    public void setBlacklisted(Boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public AwardedRewardDto getLevel() {
        return this.level;
    }

    public void setLevel(AwardedRewardDto level) {
        this.level = level;
    }

    public AwardedRewardDto getLastReward() {
        return this.lastReward;
    }

    public void setLastReward(AwardedRewardDto lastReward) {
        this.lastReward = lastReward;
    }

    public UserStatsDto getStats() {
        return this.stats;
    }

    public void setStats(UserStatsDto stats) {
        this.stats = stats;
    }

    @Override
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Override
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Override
    public List<TagDto> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<TagDto> tags) {
        this.tags = tags;
    }

    @Override
    @Generated
    public String toString() {
        return "UserDto(super=" + super.toString() + ", id=" + this.id + ", createdOn=" + this.createdOn + ", lastSeenOn=" + this.lastSeenOn + ", memberSince=" + this.memberSince + ", lastActivityOn=" + this.lastActivityOn + ", image=" + this.image + ", points=" + this.points + ", level=" + this.level + ", lastReward=" + this.lastReward + ", stats=" + this.stats + ", blacklisted=" + this.blacklisted + ", tags=" + this.tags + ", tagIds=" + this.tagIds + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserDto)) {
            return false;
        }
        UserDto other = (UserDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$blacklisted = this.blacklisted;
        Boolean other$blacklisted = other.blacklisted;
        if (this$blacklisted == null ? other$blacklisted != null : !((Object)this$blacklisted).equals(other$blacklisted)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$createdOn = this.createdOn;
        String other$createdOn = other.createdOn;
        if (this$createdOn == null ? other$createdOn != null : !this$createdOn.equals(other$createdOn)) {
            return false;
        }
        String this$lastSeenOn = this.lastSeenOn;
        String other$lastSeenOn = other.lastSeenOn;
        if (this$lastSeenOn == null ? other$lastSeenOn != null : !this$lastSeenOn.equals(other$lastSeenOn)) {
            return false;
        }
        String this$memberSince = this.memberSince;
        String other$memberSince = other.memberSince;
        if (this$memberSince == null ? other$memberSince != null : !this$memberSince.equals(other$memberSince)) {
            return false;
        }
        String this$lastActivityOn = this.lastActivityOn;
        String other$lastActivityOn = other.lastActivityOn;
        if (this$lastActivityOn == null ? other$lastActivityOn != null : !this$lastActivityOn.equals(other$lastActivityOn)) {
            return false;
        }
        ImageDto this$image = this.image;
        ImageDto other$image = other.image;
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        List<UserPointsDto> this$points = this.points;
        List<UserPointsDto> other$points = other.points;
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        AwardedRewardDto this$level = this.level;
        AwardedRewardDto other$level = other.level;
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        AwardedRewardDto this$lastReward = this.lastReward;
        AwardedRewardDto other$lastReward = other.lastReward;
        if (this$lastReward == null ? other$lastReward != null : !((Object)this$lastReward).equals(other$lastReward)) {
            return false;
        }
        UserStatsDto this$stats = this.stats;
        UserStatsDto other$stats = other.stats;
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        List<TagDto> this$tags = this.tags;
        List<TagDto> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<String> this$tagIds = this.tagIds;
        List<String> other$tagIds = other.tagIds;
        return !(this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserDto;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $blacklisted = this.blacklisted;
        result = result * 59 + ($blacklisted == null ? 43 : ((Object)$blacklisted).hashCode());
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $createdOn = this.createdOn;
        result = result * 59 + ($createdOn == null ? 43 : $createdOn.hashCode());
        String $lastSeenOn = this.lastSeenOn;
        result = result * 59 + ($lastSeenOn == null ? 43 : $lastSeenOn.hashCode());
        String $memberSince = this.memberSince;
        result = result * 59 + ($memberSince == null ? 43 : $memberSince.hashCode());
        String $lastActivityOn = this.lastActivityOn;
        result = result * 59 + ($lastActivityOn == null ? 43 : $lastActivityOn.hashCode());
        ImageDto $image = this.image;
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        List<UserPointsDto> $points = this.points;
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        AwardedRewardDto $level = this.level;
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        AwardedRewardDto $lastReward = this.lastReward;
        result = result * 59 + ($lastReward == null ? 43 : ((Object)$lastReward).hashCode());
        UserStatsDto $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        List<TagDto> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<String> $tagIds = this.tagIds;
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        return result;
    }
}

