/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.user.UsersActivityService;
import io.mambo.sdk.service.user.UsersBlacklistService;
import io.mambo.sdk.service.user.UsersCouponService;
import io.mambo.sdk.service.user.UsersCustomFieldService;
import io.mambo.sdk.service.user.UsersKpiService;
import io.mambo.sdk.service.user.UsersLeaderboardService;
import io.mambo.sdk.service.user.UsersNotificationService;
import io.mambo.sdk.service.user.UsersPointService;
import io.mambo.sdk.service.user.UsersRewardService;
import io.mambo.sdk.service.user.data.UserRequestData;
import io.mambo.sdk.service.user.model.UserDto;
import io.mambo.sdk.service.user.param.UserCreateParams;
import io.mambo.sdk.service.user.param.UserDeleteParams;
import io.mambo.sdk.service.user.param.UserGetByIdParams;
import io.mambo.sdk.service.user.param.UserGetListParams;
import io.mambo.sdk.service.user.param.UserGetParams;
import io.mambo.sdk.service.user.param.UserResetParams;
import io.mambo.sdk.service.user.param.UserSearchParams;
import io.mambo.sdk.service.user.param.UserUpdateParams;
import io.mambo.sdk.service.user.param.UserUploadParams;
import java.io.File;
import java.util.List;

public class UsersService
extends AbstractService {
    private static final String USER_URI = "/v1/users/{userId}";
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_UUID_URI = "/v1/{siteUrl}/users/{uuid}";
    private static final String USER_SEARCH_URI = "/v1/{siteUrl}/users/search";
    private static final String USER_IMAGE_URI = "/v1/{siteUrl}/users/{uuid}/image";
    private static final String USER_RESET_URI = "/v1/{siteUrl}/users/{uuid}/reset";
    private final UsersPointService pointService;
    private final UsersRewardService rewardService;
    private final UsersCouponService couponService;
    private final UsersKpiService kpiService;
    private final UsersLeaderboardService leaderboardService;
    private final UsersActivityService activityService;
    private final UsersNotificationService notificationService;
    private final UsersBlacklistService blacklistService;
    private final UsersCustomFieldService customFieldService;

    public UsersService(ApiRequestAdapter apiClient) {
        super(apiClient);
        this.pointService = new UsersPointService(apiClient);
        this.rewardService = new UsersRewardService(apiClient);
        this.couponService = new UsersCouponService(apiClient);
        this.kpiService = new UsersKpiService(apiClient);
        this.leaderboardService = new UsersLeaderboardService(apiClient);
        this.activityService = new UsersActivityService(apiClient);
        this.notificationService = new UsersNotificationService(apiClient);
        this.blacklistService = new UsersBlacklistService(apiClient);
        this.customFieldService = new UsersCustomFieldService(apiClient);
    }

    public UserDto get(String siteUrl, String uuid) {
        return this.get(UserGetParams.builder().siteUrl(siteUrl).uuid(uuid).build());
    }

    public UserDto get(UserGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public UserDto get(UserGetParams params, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_UUID_URI).responseClass(UserDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserDto getById(String userId) {
        return this.getById(UserGetByIdParams.builder().userId(userId).build());
    }

    public UserDto getById(UserGetByIdParams params) {
        return this.getById(params, RequestOptions.create());
    }

    public UserDto getById(UserGetByIdParams params, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_URI).responseClass(UserDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserDto create(UserCreateParams params, UserRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public UserDto create(String siteUrl, UserRequestData data) {
        return this.create(UserCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public UserDto create(String siteUrl, UserRequestData data, RequestOptions requestOptions) {
        return this.create(UserCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public UserDto create(UserCreateParams params, UserRequestData data, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_SITE_URI).responseClass(UserDto.class).method(HttpMethod.POST).requestData(data).params(params).options(requestOptions).build());
    }

    public UserDto update(String siteUrl, String uuid, UserRequestData data) {
        return this.update(UserUpdateParams.builder().siteUrl(siteUrl).uuid(uuid).build(), data);
    }

    public UserDto update(UserUpdateParams params, UserRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public UserDto update(UserUpdateParams params, UserRequestData data, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_UUID_URI).responseClass(UserDto.class).method(HttpMethod.PUT).requestData(data).params(params).options(requestOptions).build());
    }

    public UserDto uploadImage(String siteUrl, String uuid, File image) {
        return this.uploadImage(UserUploadParams.builder().siteUrl(siteUrl).uuid(uuid).build(), image);
    }

    public UserDto uploadImage(UserUploadParams params, File image) {
        return this.uploadImage(params, image, RequestOptions.create());
    }

    public UserDto uploadImage(UserUploadParams params, File image, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_IMAGE_URI).responseClass(UserDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image)).params(params).options(requestOptions).build());
    }

    public Status delete(String siteUrl, String uuid) {
        return this.delete(UserDeleteParams.builder().siteUrl(siteUrl).uuid(uuid).build());
    }

    public Status delete(UserDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(UserDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(USER_UUID_URI).responseClass(Status.class).method(HttpMethod.DELETE).params(params).options(requestOptions).build());
    }

    public Status reset(String siteUrl, String uuid) {
        return this.reset(UserResetParams.builder().siteUrl(siteUrl).uuid(uuid).build());
    }

    public Status reset(UserResetParams params) {
        return this.reset(params, RequestOptions.create());
    }

    public Status reset(UserResetParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(USER_RESET_URI).responseClass(Status.class).method(HttpMethod.POST).params(params).options(requestOptions).build());
    }

    public List<UserDto> getUsers(String siteUrl) {
        return this.getUsers(UserGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<UserDto> getUsers(UserGetListParams params) {
        return this.getUsers(params, RequestOptions.create());
    }

    public List<UserDto> getUsers(UserGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_SITE_URI).responseClass(UserDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<UserDto> searchUsers(String siteUrl, String searchQuery) {
        return this.searchUsers(UserSearchParams.builder().siteUrl(siteUrl).searchQuery(searchQuery).build(), RequestOptions.create());
    }

    public List<UserDto> searchUsers(UserSearchParams params) {
        return this.searchUsers(params, RequestOptions.create());
    }

    public List<UserDto> searchUsers(UserSearchParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_SEARCH_URI).responseClass(UserDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UsersPointService points() {
        return this.pointService;
    }

    public UsersRewardService rewards() {
        return this.rewardService;
    }

    public UsersCouponService coupons() {
        return this.couponService;
    }

    public UsersKpiService kpis() {
        return this.kpiService;
    }

    public UsersLeaderboardService leaderboards() {
        return this.leaderboardService;
    }

    public UsersActivityService activities() {
        return this.activityService;
    }

    public UsersNotificationService notifications() {
        return this.notificationService;
    }

    public UsersBlacklistService blacklist() {
        return this.blacklistService;
    }

    public UsersCustomFieldService customFields() {
        return this.customFieldService;
    }

    public UserRequestData newUserRequestData() {
        return new UserRequestData();
    }
}

