/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.user.model.UserAwardedRewardDto;
import io.mambo.sdk.service.user.model.UserRewardsDto;
import io.mambo.sdk.service.user.param.reward.UserGetAchievementsParams;
import io.mambo.sdk.service.user.param.reward.UserGetAllAchievementsParams;
import io.mambo.sdk.service.user.param.reward.UserGetAllGiftsParams;
import io.mambo.sdk.service.user.param.reward.UserGetAllLevelsParams;
import io.mambo.sdk.service.user.param.reward.UserGetAllMissionsParams;
import io.mambo.sdk.service.user.param.reward.UserGetAllRewardsParams;
import io.mambo.sdk.service.user.param.reward.UserGetGiftsParams;
import io.mambo.sdk.service.user.param.reward.UserGetLevelsParams;
import io.mambo.sdk.service.user.param.reward.UserGetMissionsParams;
import io.mambo.sdk.service.user.param.reward.UserGetRewardsParams;
import java.util.List;

public class UsersRewardService
extends AbstractService {
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_UUID_URI = "/v1/{siteUrl}/users/{uuid}";
    private static final String USER_REWARDS_URI = "/v1/{siteUrl}/users/{uuid}/rewards";
    private static final String USER_ALL_REWARDS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/all";
    private static final String USER_LEVELS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/levels";
    private static final String USER_ALL_LEVELS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/levels/all";
    private static final String USER_ACHIEVEMENTS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/achievements";
    private static final String USER_ALL_ACHIEVEMENTS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/achievements/all";
    private static final String USER_MISSIONS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/missions";
    private static final String USER_ALL_MISSIONS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/missions/all";
    private static final String USER_GIFTS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/gifts";
    private static final String USER_ALL_GIFTS_URI = "/v1/{siteUrl}/users/{uuid}/rewards/gifts/all";

    public UsersRewardService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public List<UserAwardedRewardDto> getRewards(String siteUrl, String uuid) {
        return this.getRewards(UserGetRewardsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getRewards(UserGetRewardsParams params) {
        return this.getRewards(params, RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getRewards(UserGetRewardsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_REWARDS_URI).responseClass(UserAwardedRewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserRewardsDto getAllRewards(String siteUrl, String uuid) {
        return this.getAllRewards(UserGetAllRewardsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public UserRewardsDto getAllRewards(UserGetAllRewardsParams params) {
        return this.getAllRewards(params, RequestOptions.create());
    }

    public UserRewardsDto getAllRewards(UserGetAllRewardsParams params, RequestOptions requestOptions) {
        return (UserRewardsDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_ALL_REWARDS_URI).responseClass(UserRewardsDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<UserAwardedRewardDto> getLevels(String siteUrl, String uuid) {
        return this.getLevels(UserGetLevelsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getLevels(UserGetLevelsParams params) {
        return this.getLevels(params, RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getLevels(UserGetLevelsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_LEVELS_URI).responseClass(UserAwardedRewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserRewardsDto getAllLevels(String siteUrl, String uuid) {
        return this.getAllLevels(UserGetAllLevelsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public UserRewardsDto getAllLevels(UserGetAllLevelsParams params) {
        return this.getAllLevels(params, RequestOptions.create());
    }

    public UserRewardsDto getAllLevels(UserGetAllLevelsParams params, RequestOptions requestOptions) {
        return (UserRewardsDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_ALL_LEVELS_URI).responseClass(UserRewardsDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<UserAwardedRewardDto> getAchievements(String siteUrl, String uuid) {
        return this.getAchievements(UserGetAchievementsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getAchievements(UserGetAchievementsParams params) {
        return this.getAchievements(params, RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getAchievements(UserGetAchievementsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_ACHIEVEMENTS_URI).responseClass(UserAwardedRewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserRewardsDto getAllAchievements(String siteUrl, String uuid) {
        return this.getAllAchievements(UserGetAllAchievementsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public UserRewardsDto getAllAchievements(UserGetAllAchievementsParams params) {
        return this.getAllAchievements(params, RequestOptions.create());
    }

    public UserRewardsDto getAllAchievements(UserGetAllAchievementsParams params, RequestOptions requestOptions) {
        return (UserRewardsDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_ALL_ACHIEVEMENTS_URI).responseClass(UserRewardsDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<UserAwardedRewardDto> getGifts(String siteUrl, String uuid) {
        return this.getGifts(UserGetGiftsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getGifts(UserGetGiftsParams params) {
        return this.getGifts(params, RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getGifts(UserGetGiftsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_GIFTS_URI).responseClass(UserAwardedRewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserRewardsDto getAllGifts(String siteUrl, String uuid) {
        return this.getAllGifts(UserGetAllGiftsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public UserRewardsDto getAllGifts(UserGetAllGiftsParams params) {
        return this.getAllGifts(params, RequestOptions.create());
    }

    public UserRewardsDto getAllGifts(UserGetAllGiftsParams params, RequestOptions requestOptions) {
        return (UserRewardsDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_ALL_GIFTS_URI).responseClass(UserRewardsDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<UserAwardedRewardDto> getMissions(String siteUrl, String uuid) {
        return this.getMissions(UserGetMissionsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getMissions(UserGetMissionsParams params) {
        return this.getMissions(params, RequestOptions.create());
    }

    public List<UserAwardedRewardDto> getMissions(UserGetMissionsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_MISSIONS_URI).responseClass(UserAwardedRewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public UserRewardsDto getAllMissions(String siteUrl, String uuid) {
        return this.getAllMissions(UserGetAllMissionsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public UserRewardsDto getAllMissions(UserGetAllMissionsParams params) {
        return this.getAllMissions(params, RequestOptions.create());
    }

    public UserRewardsDto getAllMissions(UserGetAllMissionsParams params, RequestOptions requestOptions) {
        return (UserRewardsDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_ALL_MISSIONS_URI).responseClass(UserRewardsDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }
}

