/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.model.response.ResponseEntity;
import io.mambo.sdk.service.point.model.PointTransactionDto;
import io.mambo.sdk.service.point.model.PointWalletDto;
import io.mambo.sdk.service.user.param.point.UserGetPointTransactionsParams;
import io.mambo.sdk.service.user.param.point.UserGetPointWalletsParams;

public class UsersPointService
extends AbstractService {
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_UUID_URI = "/v1/{siteUrl}/users/{uuid}";
    private static final String USER_POINT_WALLETS_URI = "/v1/{siteUrl}/users/{uuid}/points/wallets";
    private static final String USER_POINT_TRANSACTIONS_URI = "/v1/{siteUrl}/users/{uuid}/points/transactions/{pointId}";

    protected UsersPointService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public ResponseEntity<PointWalletDto> getPointWallets(String siteUrl, String uuid) {
        return this.getPointWallets(UserGetPointWalletsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public ResponseEntity<PointWalletDto> getPointWallets(UserGetPointWalletsParams params) {
        return this.getPointWallets(params, RequestOptions.create());
    }

    public ResponseEntity<PointWalletDto> getPointWallets(UserGetPointWalletsParams params, RequestOptions requestOptions) {
        return (ResponseEntity)this.apiClient().request(ApiRequest.builder().apiPath(USER_POINT_WALLETS_URI).responseClass(PointWalletDto.class).responseType(ResponseType.RESPONSE_ENTITY).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public ResponseEntity<PointTransactionDto> getPointTransactions(String siteUrl, String uuid, String pointId) {
        return this.getPointTransactions(UserGetPointTransactionsParams.builder().siteUrl(siteUrl).uuid(uuid).pointId(pointId).build(), RequestOptions.create());
    }

    public ResponseEntity<PointTransactionDto> getPointTransactions(UserGetPointTransactionsParams params) {
        return this.getPointTransactions(params, RequestOptions.create());
    }

    public ResponseEntity<PointTransactionDto> getPointTransactions(UserGetPointTransactionsParams params, RequestOptions requestOptions) {
        return (ResponseEntity)this.apiClient().request(ApiRequest.builder().apiPath(USER_POINT_TRANSACTIONS_URI).responseClass(PointTransactionDto.class).responseType(ResponseType.RESPONSE_ENTITY).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }
}

